package com.agilex.healthcare.directscheduling.validator;

import com.agilex.healthcare.directscheduling.enumeration.MdwsError;

import org.springframework.stereotype.Component;

@Component
public class VARResponseValidator {

    private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(VARResponseValidator.class);

    private static final char Message_Delimiter = '^';
    private static final String GENERIC_BOOKING_ERROR = "An error occurred while booking the appointment.";

    public <T extends com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.AbstractTO> String validateMdwsObject(T t){
        if(t.getFault() != null){
            logger.error("MDWSLib MdwsResponseValidator Exception : " + t.getFault().getMessage());
            if(t.getFault().getMessage().contains(MdwsError.APPOINTMENT_TIME_OUT_OF_RANGE.toString())){
                return stripTheErrorMessage(t.getFault().getMessage());
            }
            if(t.getFault().getMessage().contains(MdwsError.SAME_DAY_APPOINTMENT_ERROR.toString())){
                return stripTheErrorMessage(t.getFault().getMessage());
            }
            if(t.getFault().getMessage().contains(MdwsError.PATIENT_SAME_SLOT_APPOINTMENT.toString())){
                return stripTheErrorMessage(t.getFault().getMessage());
            }
            if(t.getFault().getMessage().contains(MdwsError.TIME_PREVIOUSLY_CANCLED_BY_PATIENT.toString())){
                return stripTheErrorMessage(t.getFault().getMessage());
            }
            if(t.getFault().getMessage().contains(MdwsError.OVERBOOK_NOT_ALLOWED.toString())){
                return stripTheErrorMessage(t.getFault().getMessage());
            }
            if(t.getFault().getMessage().contains(MdwsError.EXCEEDS_MAX_ALLOWED_OVERBOOK_PER_DAY.toString())){
                return stripTheErrorMessage(t.getFault().getMessage());
            }
            if(t.getFault().getMessage().contains(MdwsError.PATIENT_HAS_DIED.toString())){
                return stripTheErrorMessage(t.getFault().getMessage());
            }
            if(t.getFault().getMessage().contains(MdwsError.APPOINTMENT_DATE_PRIOR_TO_DOB.toString())){
                return stripTheErrorMessage(t.getFault().getMessage());
            }
            if(t.getFault().getMessage().contains(MdwsError.APPOINTMENT_DATE_PRIOR_TO_CLINIC_AVAILABILITY.toString())){
                return stripTheErrorMessage(t.getFault().getMessage());
            }
            if(t.getFault().getMessage().contains(MdwsError.NO_AVAILABLE_SLOT_FOR_DATE_TIME.toString())){
                return stripTheErrorMessage(t.getFault().getMessage());
            }
            if(t.getFault().getMessage().contains(MdwsError.EXCEEDS_MAX_DAYS_IN_FUTURE.toString())){
                return stripTheErrorMessage(t.getFault().getMessage());
            }
            if(t.getFault().getMessage().contains(MdwsError.HOLIDAY.toString())){
                return stripTheErrorMessage(t.getFault().getMessage());
            }
            if(t.getFault().getMessage().contains(MdwsError.CAN_NOT_BOOK_WITHIN_CANCELED_TIME_PERIOD.toString())){
                return stripTheErrorMessage(t.getFault().getMessage());
            }
            if(t.getFault().getMessage().contains(MdwsError.NO_OPEN_SLOT.toString())){
                return stripTheErrorMessage(t.getFault().getMessage());
            }
            if(t.getFault().getMessage().contains(MdwsError.NO_ACCESS_TO_CLINIC.toString())){
                return stripTheErrorMessage(t.getFault().getMessage());
            }
            return GENERIC_BOOKING_ERROR;
        }
        return "";
    }

    public String stripTheErrorMessage(String errorString){
        int indexOfFirstOccurrence = errorString.indexOf(Message_Delimiter);
        if(indexOfFirstOccurrence >= 0){
            int indexOfSecondOccurrence = errorString.indexOf(Message_Delimiter, indexOfFirstOccurrence+1);
            if(indexOfSecondOccurrence > indexOfFirstOccurrence){
                return errorString.substring(indexOfFirstOccurrence+1, indexOfSecondOccurrence);
            }
        }
        return errorString;
    }
}
